/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Config;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class DeferredElectricRenderer {
    private static DeferredElectricRenderer instance;
    private final ResourceLocation nodeTexture = new ResourceLocation("refurbished_furniture", "textures/misc/electricity_nodes.png");
    private final List<BiConsumer<PoseStack, VertexConsumer>> builders = new LinkedList<BiConsumer<PoseStack, VertexConsumer>>();

    public static DeferredElectricRenderer get() {
        if (instance == null) {
            instance = new DeferredElectricRenderer();
        }
        return instance;
    }

    private DeferredElectricRenderer() {
    }

    public void draw(PoseStack pose) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget target = mc.f_91060_.m_109827_();
        if (target == null || this.builders.isEmpty()) {
            return;
        }
        if (((Boolean)Config.CLIENT.experimental.electricityShadersFix.get()).booleanValue()) {
            target.m_83954_(Minecraft.f_91002_);
        }
        target.m_83947_(false);
        Tesselator tesselator = Tesselator.m_85913_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.nodeTexture);
        pose.m_85836_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        for (BiConsumer<PoseStack, VertexConsumer> consumer : this.builders) {
            consumer.accept(pose, (VertexConsumer)builder);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        mc.m_91385_().m_83947_(false);
        this.builders.clear();
    }

    public void deferDraw(BiConsumer<PoseStack, VertexConsumer> consumer) {
        this.builders.add(consumer);
    }

    public void drawColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)FastColor.ARGB32.m_13665_((int)colour) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)colour) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxV, minU).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minV, minU).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minV, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxV, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public void drawInvertedColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)FastColor.ARGB32.m_13665_((int)colour) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)colour) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public void drawTexturedBox(Matrix4f matrix, VertexConsumer consumer, AABB box, float minU, float minV, float maxU, float maxV) {
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(maxU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxV, minU).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minV, minU).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(minV, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(maxV, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(maxU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(minU, minV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
    }
}

